import { createClient } from "https://cdn.jsdelivr.net/npm/@supabase/supabase-js/+esm"

const SUPABASE_KEY =
  "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6ImZvdW9rZGFwa2NsanJ4anFxZ3RoIiwicm9sZSI6ImFub24iLCJpYXQiOjE3MjA1NjkzNTksImV4cCI6MjAzNjE0NTM1OX0.JYazlVWh1__j-Xf2Qz6FBIX9tqrdZJKnvYIUaIk3hUo"
const SUPABASE_URL = "https://fouokdapkcljrxjqqgth.supabase.co"
const supabase = createClient(SUPABASE_URL, SUPABASE_KEY)

document.addEventListener("DOMContentLoaded", async () => {
  // Check if user is already logged in
  const { data: sessionExists, error } = await supabase.auth.getSession()
  if (sessionExists.session) {
    window.location.href = "./onboarding"
  }

  // Attach SignUp event to the form
  const signUpForm = document.getElementById("sign-up")
  signUpForm.addEventListener("submit", signUpSubmitted)
})

// SignUp function
async function signUpSubmitted(event) {
  event.preventDefault() // Prevent form from submitting the traditional way
  const sendEmail = ({ firstName, lastName, email, mobile }) => {
    const xhr = new XMLHttpRequest()
    console.log(xhr)
    xhr.open("POST", "send_email.php")
    xhr.setRequestHeader("Content-Type", "application/json")
    xhr.onload = () => {
      if (xhr.status == 200) {
        console.log("good")
      }
    }
    xhr.send(
      JSON.stringify({
        email,
        personalizations: [{ to: [{ email: "josedpacheco9520@gmail.com" }] }],
        from: { email: "josepacheco9520@gmail.com" },
        subject: "A4P Onboarding Contractor",
        content: [
          {
              type: "text/plain",
            value: `First Name:${firstName} \n Last Name: ${lastName} \n email: ${email} \n Mobile: ${mobile}`,
          },
        ],
      })
    )
  }
  // Collect form data
  const first_name = document.getElementById("firstNameInput").value
  const last_name = document.getElementById("lastNameInput").value
  const email = document.getElementById("emailInput").value
  const mobile_number = document.getElementById("mobileNumber").value
  const password = document.getElementById("passwordInput").value

  console.log(first_name, last_name, email, password, mobile_number)
  
  supabase.auth
    .signUp({
      email: email,
      password: password,
      options: {
        data: {
          mobile_number: mobile_number,
          first_name: first_name,
          last_name: last_name,
        },
      },
    })
    .then((response) => {
        if (response.error) {
          alert(response.error.message)
        } else {
          sendEmail({
            firstName: first_name,
            lastName: last_name,
            email,
            mobile: mobile_number,
          })
          window.location.href = "./onboarding"
        }
    })
    .catch((err) => {
      alert(err.response.text)
    })
}
