import { createClient } from "https://cdn.jsdelivr.net/npm/@supabase/supabase-js/+esm"

const SUPABASE_KEY =
  "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6ImZvdW9rZGFwa2NsanJ4anFxZ3RoIiwicm9sZSI6ImFub24iLCJpYXQiOjE3MjA1NjkzNTksImV4cCI6MjAzNjE0NTM1OX0.JYazlVWh1__j-Xf2Qz6FBIX9tqrdZJKnvYIUaIk3hUo"
const SUPABASE_URL = "https://fouokdapkcljrxjqqgth.supabase.co"
const supabase = createClient(SUPABASE_URL, SUPABASE_KEY)
// const onboardingPagesID = ['company', 'specialties', 'onboarding', 'thank-you']
const backButtons = ["specialties", "services", "onboarding"]
let onboardingPage = localStorage.getItem("onboarding_page")
  ? localStorage.getItem("onboarding_page")
  : "company"
document.getElementById(onboardingPage)?.removeAttribute("hidden")
//onboardingPagesID.filter(id => id != onboardingPage)
document.addEventListener("DOMContentLoaded", async () => {
  // Check if user is already logged in
  const { data: sessionExists, error } = await supabase.auth.getSession()
  // if (!localStorage.getItem('sessionUserID') && sessionExists) {
  //     localStorage.setItem('sessionUserID',  sessionExists.session.user.id)
  // }
  if (!sessionExists.session) {
    window.location.href = "../../auth/login"
  }
  if (
    localStorage.getItem("onboarding_page") &&
    localStorage.getItem("onboarding_page") == "specialties"
  ) {
    await getIndustries()
  }
  if (
    localStorage.getItem("onboarding_page") &&
    localStorage.getItem("onboarding_page") == "services"
  ) {
    await getServices()
  }

  if (
    localStorage.getItem("onboarding_page") &&
    localStorage.getItem("onboarding_page") == "onboarding"
  ) {
  }

  // Check if user is already registered as a partner
  const { data: partnerExists } = await supabase
    .from("partner")
    .select("*")
    .eq("user_id", sessionExists.session.user.id)
  // if (partnerExists.length < 1) {
  //     document.getElementById('company').removeAttribute('hidden');
  // } else {
  //     const { data: user } = await supabase.auth.getSession();
  //     if (!user.session.user.user_metadata.specialties) {
  //         await getIndustries();
  //         document.getElementById('specialties').removeAttribute('hidden');
  //     } else {
  //         // Check if user has selected services
  //         const { data: partnerServices } = await supabase.from('partner_service').select('*').eq('user_id', sessionExists.session.user.id);
  //         if (partnerServices.length < 1) {
  //             await getServices();
  //             document.getElementById('services').removeAttribute('hidden');
  //         } else {
  //             document.getElementById('onboarding').removeAttribute('hidden');
  //         }
  //     }
  // }

  // Submission event listners
  const partnerForm = document.getElementById("partner-form")
  partnerForm.addEventListener("submit", registerPartner)

  const specialtyForm = document.getElementById("submit-specialties")
  specialtyForm.addEventListener("click", registerSpecialties)

  const serviceForm = document.getElementById("submit-services")
  serviceForm.addEventListener("click", registerServices)

  const termsForm = document.getElementById("submit-acceptance")
  termsForm.addEventListener("click", registerAcceptance)

  backButtons.forEach((id) => {
    document
      .getElementById(`back-button-${id}`)
      .addEventListener("click", (e) => {
        e.preventDefault()
        handleBack(id)
      })
  })
  handlePopulate(onboardingPage)
  //   const specialties = document.getElementById("specialties")
  //   const services = document.getElementById("services")

  //   const observerSpecialties = new MutationObserver(() => {
  //     console.log('new specialties')
  //   })
  //   const observerServices = new MutationObserver(() => {
  //     console.log('new services')
  //   })
  //   observerSpecialties.observe(specialties)
  //   observerServices.observe(services)
})

async function registerAcceptance(event) {
  event.preventDefault() // Prevent form from submitting the traditional way
  try {
    const service_ids = localStorage.getItem("services")
      ? JSON.parse(localStorage.getItem("services"))
      : []
    await supabase.from("partner_service").insert(
      service_ids.map(({ partner_id, user_id, service_id }) => ({
        partner_id,
        user_id,
        service_id,
      }))
    )
  } catch (e) {
    console.log(e)
  }
  document.getElementById("onboarding").setAttribute("hidden", true)
  document.getElementById("thank-you").removeAttribute("hidden")
  localStorage.setItem("onboarding_page", "thank-you")
}

async function registerServices(event) {
  event.preventDefault() // Prevent form from submitting the traditional way

  // Get the user ID from the session
  const { data: session } = await supabase.auth.getSession()
  const user_id = session.session.user.id

  // Get partner id from the partner table
  const { data: partner } = await supabase
    .from("partner")
    .select("partner_id")
    .eq("user_id", user_id)
  const partner_id = partner[0].partner_id

  // Get all the checkboxes within the services div
  const checkboxes = document.querySelectorAll(
    '#services input[type="checkbox"]:checked'
  )

  // Get the service IDs from the checkboxes
  const service_ids = Array.from(checkboxes).map((checkbox) =>
    parseInt(checkbox.id.split("-")[1])
  )

  // If empty specialties, alert the user and return early
  if (service_ids.length === 0) {
    alert("Please select at least one service")
    return
  }

  try {
    // Insert specialties into supabase partner_services table
    // await supabase
    //   .from("partner_service")
    //   .delete()
    //   .eq("user_id", user_id)
    // const { data, error } = await supabase
    //   .from("partner_service")
    //   .insert(
    //     service_ids.map((service_id) => ({ partner_id, user_id, service_id }))
    //   )
    localStorage.setItem(
      "services",
      JSON.stringify(
        service_ids.map((service_id) => ({ partner_id, user_id, service_id }))
      )
    )
    document.getElementById("services").setAttribute("hidden", true)
    document.getElementById("onboarding").removeAttribute("hidden")
    localStorage.setItem("onboarding_page", "onboarding")
  } catch (error) {
    console.error(error)
    alert("An error occurred while registering the partner services")
  }
}

async function registerSpecialties(event) {
  event.preventDefault() // Prevent form from submitting the traditional way

  // Get the user ID from the session
  const { data: session } = await supabase.auth.getSession()
  const user_id = session.session.user.id

  // Get all the checkboxes within the specialties div
  const checkboxes = document.querySelectorAll(
    '#specialties input[type="checkbox"]:checked'
  )

  // Get the specialty IDs from the checkboxes
  const specialty_ids = Array.from(checkboxes).map((checkbox) =>
    parseInt(checkbox.id.split("-")[1])
  )

  // If empty specialties, alert the user and return early
  if (specialty_ids.length === 0) {
    alert("Please select at least one specialty")
    return
  }

  try {
    // Insert specialties into supabase user table metadata using updateUser() method
    const { data, error } = await supabase.auth.updateUser({
      data: { specialties: specialty_ids },
    })
    document.getElementById("specialties").setAttribute("hidden", true)
    await getServices()
    document.getElementById("services").removeAttribute("hidden")
    localStorage.setItem("onboarding_page", "services")
    if (error) {
      throw error
    }
  } catch (error) {
    console.error(error)
    alert("An error occurred while registering the partner specialties")
  }
}

async function registerPartner(event) {
  event.preventDefault() // Prevent form from submitting the traditional way

  // Collect form data
  const name = document.getElementById("companyName").value
  const address = document.getElementById("address").value
  const address2 = document.getElementById("address2").value
  const city = document.getElementById("city").value
  const state = document.getElementById("state").value
  const zip = document.getElementById("zip").value

  // Get the user ID from the session
  const { data: session } = await supabase.auth.getSession()
  const user_id = session.session.user.id

  try {
    // Insert partner data into the 'partner' table
    const partner = await supabase
      .from("partner")
      .select()
      .eq("user_id", user_id)
    const { data, error } =
      partner.data && partner.data.length
        ? await supabase
            .from("partner")
            .update({
              name,
              address,
              city,
              state,
              zip_code: zip,
              address2,
              user_id,
            })
            .eq("partner_id", partner.data[0].partner_id)
        : await supabase
            .from("partner")
            .insert([
              { name, address, city, state, zip_code: zip, address2, user_id },
            ])

    if (error) {
      throw error
    }

    // Make div id company-info hidden and remove hidden from div id specialties
    document.getElementById("company").setAttribute("hidden", true)
    await getIndustries()
    localStorage.setItem("onboarding_page", "specialties")
    document.getElementById("specialties").removeAttribute("hidden")
  } catch (error) {
    console.error(error)
    alert("An error occurred while registering the partner")
  }
}

const getSpecialties = async (industry_id) => {
  const { data: specialties, error } = await supabase
    .from("specialty")
    .select("*")
    .eq("industry_id", industry_id)
  if (error) {
    console.error(error)
  }
  return specialties
}

async function getIndustries() {
  const { data: industries } = await supabase.from("industry").select("*")
  const { data: user } = await supabase.auth.getSession()
  const specialtiesIDs =
    user &&
    user.session &&
    user.session.user &&
    user.session.user.user_metadata &&
    user.session.user.user_metadata.specialties
      ? user.session.user.user_metadata.specialties
      : []
  const industryList = document.getElementById("industries")
  const industryAccordion = document.createElement("div")
  industryAccordion.className = "accordion"
  industryAccordion.id = "accordionExample"

  industries.forEach((industry) => {
    const existDiv = document.getElementById(`industry-${industry.industry_id}`)
    if (existDiv) existDiv.remove()
    const accordionItem = document.createElement("div")
    accordionItem.id = `industry-${industry.industry_id}`
    const header = document.createElement("h2")
    const strong = document.createElement("strong")
    const button = document.createElement("button")
    const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg")
    const use = document.createElementNS("http://www.w3.org/2000/svg", "use")
    const collapse = document.createElement("div")
    const collapseBody = document.createElement("div")

    // Function to convert to lowercase and replace spaces with hyphens
    const formatIndustryName = (name) => {
      return name.toLowerCase().replace(/\s+/g, "-")
    }

    const formattedName = formatIndustryName(industry.name)

    // Button configuration
    button.className = "accordion-button collapsed"
    button.type = "button"
    button.setAttribute("data-bs-toggle", "collapse")
    button.setAttribute("data-bs-target", `#collapse${industry.industry_id}`)
    button.setAttribute("aria-expanded", "false")
    button.setAttribute("aria-controls", `collapse${industry.industry_id}`)

    // SVG configuration
    svg.setAttribute("width", "24")
    svg.setAttribute("height", "24")
    use.setAttributeNS(
      "http://www.w3.org/1999/xlink",
      "xlink:href",
      `#${formattedName}`
    )
    svg.appendChild(use)

    // Strong configuration
    strong.textContent = industry.name
    strong.style.marginLeft = "20px"

    // Assemble button
    button.appendChild(svg)
    button.appendChild(strong)

    // Header configuration
    header.className = "accordion-header"
    header.appendChild(button)

    // Accordion item configuration
    accordionItem.className = "accordion-item"
    accordionItem.appendChild(header)

    // Collapse body configuration
    collapseBody.className = "accordion-body"

    // Collapse configuration
    collapse.className = "accordion-collapse collapse"
    collapse.setAttribute("data-bs-parent", "#accordionExample")
    collapse.setAttribute("id", `collapse${industry.industry_id}`)
    collapse.appendChild(collapseBody)

    // Append collapse to accordion item
    accordionItem.appendChild(collapse)

    // Get specialties and create list items
    getSpecialties(industry.industry_id).then((specialties) => {
      const listGroup = document.createElement("ul")
      listGroup.className = "list-group"

      specialties.forEach((specialty) => {
        const specialtyFinded = specialtiesIDs.find(
          (spec) => spec == specialty.specialty_id
        )

        const listItem = document.createElement("li")
        const input = document.createElement("input")
        const label = document.createElement("label")

        input.className = "form-check-input me-1"
        input.type = "checkbox"
        input.value = ""
        input.id = `specialty-${specialty.specialty_id}`
        if (specialtyFinded) input.checked = true
        label.className = "form-check-label stretched-link"
        label.setAttribute("for", `specialty-${specialty.specialty_id}`)
        label.textContent = specialty.name

        listItem.className = "list-group-item"
        listItem.appendChild(input)
        listItem.appendChild(label)

        listGroup.appendChild(listItem)
      })

      collapseBody.appendChild(listGroup)
    })

    // Append accordion item to the main container
    industryAccordion.appendChild(accordionItem)
  })

  industryList.appendChild(industryAccordion)
}

async function getServices() {
  // Get specialties from the user metadata
  const { data: user } = await supabase.auth.getSession()
  const metadata = user.session.user.user_metadata.specialties
  const servicesPrevious = localStorage.getItem("services")
    ? JSON.parse(localStorage.getItem("services"))
    : []
  // Get specialties from specialty table
  const { data: specialties } = await supabase
    .from("specialty")
    .select("*")
    .in("specialty_id", metadata)
  // Get services from service table
  const { data: services } = await supabase
    .from("service")
    .select("*")
    .in("specialty_id", metadata)

  const specialtyList = document.getElementById("specialty-display")

  const specialtyAccordion = document.createElement("div")
  specialtyAccordion.className = "accordion"
  specialtyAccordion.id = "specialtyAccordion"

  specialties.forEach((specialty) => {
    const existDiv = document.getElementById(
      `specialty-accordion-${specialty.specialty_id}`
    )
    if (existDiv) {
      existDiv.remove()
    }
    const accordionItem = document.createElement("div")
    accordionItem.id = `specialty-accordion-${specialty.specialty_id}`
    const header = document.createElement("h2")
    const strong = document.createElement("strong")
    const button = document.createElement("button")
    const collapse = document.createElement("div")
    const collapseBody = document.createElement("div")

    // Button configuration
    button.className = "accordion-button collapsed"
    button.type = "button"
    button.setAttribute("data-bs-toggle", "collapse")
    button.setAttribute("data-bs-target", `#collapse${specialty.specialty_id}`)
    button.setAttribute("aria-expanded", "false")
    button.setAttribute("aria-controls", `collapse${specialty.specialty_id}`)

    // Strong configuration
    strong.textContent = specialty.name
    //strong.style.marginLeft = '20px';

    // Assemble button
    button.appendChild(strong)

    // Header configuration
    header.className = "accordion-header"
    header.appendChild(button)

    // Accordion item configuration
    accordionItem.className = "accordion-item"
    accordionItem.appendChild(header)

    // Collapse body configuration
    collapseBody.className = "accordion-body"

    // Collapse configuration
    collapse.className = "accordion-collapse collapse"
    collapse.setAttribute("data-bs-parent", "#accordionExample")
    collapse.setAttribute("id", `collapse${specialty.specialty_id}`)

    const listGroup = document.createElement("ul")
    listGroup.className = "list-group"
    // Get services where specialty_id is equal to specialty.specialty_id
    const specialtyServices = services.filter(
      (service) => service.specialty_id === specialty.specialty_id
    )

    specialtyServices.forEach((service) => {
      const serviceFinded = servicesPrevious.find(
        (serv) => serv.service_id == service.service_id
      )

      const listItem = document.createElement("li")
      const input = document.createElement("input")
      const label = document.createElement("label")
      input.className = "form-check-input me-1"
      input.type = "checkbox"
      input.value = ""
      if (serviceFinded) input.checked = true
      input.id = `service-${service.service_id}`
      label.className = "form-check-label stretched-link"
      label.setAttribute("for", `service-${service.service_id}`)
      label.textContent = service.name
      listItem.className = "list-group-item"
      listItem.appendChild(input)
      listItem.appendChild(label)

      listGroup.appendChild(listItem)
    })

    collapseBody.appendChild(listGroup)

    collapse.appendChild(collapseBody)

    // Append collapse to accordion item
    accordionItem.appendChild(collapse)

    // Append accordion item to the main container
    specialtyAccordion.appendChild(accordionItem)
  })

  specialtyList.appendChild(specialtyAccordion)
}

// industries.forEach(industry => {
//     const listItem = document.createElement('li');
//     const link = document.createElement('a');
//     const svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
//     const use = document.createElementNS('http://www.w3.org/2000/svg', 'use');
//     const div = document.createElement('div');
//     const strong = document.createElement('strong');

//     // Function to convert to lowercase and replace spaces with hyphens
//     const formatIndustryName = (name) => {
//         return name.toLowerCase().replace(/\s+/g, '-');
//     };

//     // Set attributes and classes for the link
//     link.href = "#";
//     link.className = "btn btn-hover-light rounded-2 d-flex align-items-start gap-2 py-2 px-3 lh-sm text-start";

//     // Set attributes for the SVG and use elements
//     svg.setAttribute('width', '24');
//     svg.setAttribute('height', '24');
//     use.setAttributeNS('http://www.w3.org/1999/xlink', 'xlink:href', `#${formatIndustryName(industry.name)}`);

//     // Append use to svg, svg to link
//     svg.appendChild(use);
//     link.appendChild(svg);

//     // Set text content for the strong element and append it to the div
//     strong.className = "d-block";
//     strong.textContent = industry.name;
//     div.appendChild(strong);

//     // Append div to link, link to listItem
//     link.appendChild(div);
//     listItem.appendChild(link);

//     // Append listItem to the list (assuming industryList is the UL element)
//     industryList.appendChild(listItem);
// });

const handleBack = async (id) => {
  let newID = ""
  if (id == "specialties") {
    newID = "company"
  }
  if (id == "services") {
    newID = "specialties"
    await getIndustries()
  }
  if (id == "onboarding") {
    await getSpecialties()
    newID = "services"
  }

  if (id == "specialties") handlePopulate(newID)
  document.getElementById(newID).removeAttribute("hidden")
  document.getElementById(id).setAttribute("hidden", true)
  localStorage.setItem("onboarding_page", newID)
}

const handlePopulate = async (id) => {
  const { data: session } = await supabase.auth.getSession()
  const user_id = session.session.user.id
  if (id == "company") {
    const { data, error } = await supabase
      .from("partner")
      .select()
      .eq("user_id", user_id)
    if (data.length) {
      const partner = data[0]
      if (partner.name) {
        document.getElementById("companyName").value = partner.name
      }
      if (partner.address) {
        document.getElementById("address").value = partner.address
      }
      if (partner.address2) {
        document.getElementById("address2").value = partner.address2
      }
      if (partner.city) {
        document.getElementById("city").value = partner.city
      }
      if (partner.state) {
        document.getElementById("state").value = partner.state
      }
      if (partner.zip_code) {
        document.getElementById("zip").value = partner.zip_code
      }
    }
  }
  if (id == "specialties") {
    // if (
    //     session &&
    //     session.session &&
    //     session.session.user &&
    //     session.session.user.user_metadata.specialties
    // ) {
    //     session.session.user.user_metadata.specialties.forEach(inputID => {
    //         const checkbox = document.getElementById(`specialty-${inputID}`)
    //         checkbox.checked = true
    //     })
    // }
  }
  if (id == "services") {
    // await getServices()
  }
}
