import { createClient } from 'https://cdn.jsdelivr.net/npm/@supabase/supabase-js/+esm'

const SUPABASE_KEY = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6ImZvdW9rZGFwa2NsanJ4anFxZ3RoIiwicm9sZSI6ImFub24iLCJpYXQiOjE3MjA1NjkzNTksImV4cCI6MjAzNjE0NTM1OX0.JYazlVWh1__j-Xf2Qz6FBIX9tqrdZJKnvYIUaIk3hUo'
const SUPABASE_URL = "https://fouokdapkcljrxjqqgth.supabase.co"
const supabase = createClient(SUPABASE_URL, SUPABASE_KEY);

document.addEventListener('DOMContentLoaded', async () => {
    // Check if user is already logged in
    const { data: sessionExists, error } = await supabase.auth.getSession();
    if (sessionExists.session) {
        window.location.href = '../../registration/onboarding';
    }

    // Attach login event to the form
    const loginForm = document.getElementById('login-form');
    loginForm.addEventListener('submit', login);
});

// Login function
async function login(event) {
    event.preventDefault(); // Prevent form from submitting the traditional way

    // Collect form data
    const email = document.getElementById('email').value;
    const password = document.getElementById('password').value;

    try {
        // Supabase login
        const { error } = await supabase.auth.signInWithPassword({ email, password });

        if (error) {
            throw error;
        }

        window.location.href = '../../registration/onboarding';
    } catch (error) {
        console.error(error);
        alert('An error occurred while logging in');
    }
}
